// TriangulatorMarchCubes.h
// Implementation des marching cubes qui travaille par couche de cubes

#ifndef V3D_BLOBS_MARCH_CUBES_LAYER_BY_LAYER_H_INCLUDED
#define V3D_BLOBS_MARCH_CUBES_LAYER_BY_LAYER_H_INCLUDED

#include "TriangulatorMarchCubes.h"
#include "ScanLines.h"


namespace V3D {


//////////////////////////////////////////////////////////////////////////////////////////

class MarchCubesByLayers : public TriangulatorMarchCubes
{
	typedef TriangulatorMarchCubes parent;

public:
	// Constructeur / Destructeur
	virtual ~MarchCubesByLayers();
	MarchCubesByLayers(const Vector3D& vcCenterGrid, const Vector3D& vcSize, 
	                   int32 nDivideX, int32 nDivideY, int32 nDivideZ,
	                   int32 nRefineLevel = 0 );

	void SetRefineLevel( int32 nIterCount );

	void SetCleanupTriangles( bool bCleanup = true);


	void InitGrid( const Vector3D& vcCenterGrid, const Vector3D& vcSize, 
				   int32 nDivideX, int32 nDivideY, int32 nDivideZ);

	virtual void GenerateMesh( const IsoSurface& iso, 
								Vect3DArray& aVertices, TriangleArray& aTriangles,
								Vect3fArray* paNorms = 0, bool bNormalizeNormals = false );

	static void ComputeNormalsFromTopology( Vect3fArray& aNorms,
									        const Vect3DArray& aVerts,
									        const TriangleArray& aTris );


									////////////////////////////////////

protected:
	typedef std::vector<float> DensityArray;
	typedef std::vector<int32> VtxIndexArray;
	typedef std::vector<char>  BoolArray;    // Pas vector<bool> qui est plus compact mais plus lent d'acces!!!

protected:

	void UpdateBufferSizes(int32 nDivideX, int32 nDivideY);

	void GenerateGeometryInGrid( Vect3DArray& aVertices, TriangleArray& aTriangles,
								 const IsoSurface& iso, 
								 const Vector3D& vcStartGrid, int32 nCubesX, int32 nCubesY, int32 nCubesZ);

	// Cree les vertices de l'isosurface pour un plan de Z constant
	int32 ComputeZPlaneVertices( Vect3DArray& aVertices,
	                             VtxIndexArray& aiVtxPlaneXAxis, VtxIndexArray& aiVtxPlaneYAxis,
	                             BoolArray& abCubesInteressantsCurLayer, BoolArray& abCubesInteressantsPrvLayer,
	                             const Vector3D& vcLayerCorner, int32 nCubesX, int32 nCubesY,
	                             const DensityArray& afPlanePotentials, 
	                             const AllScansArray& aScansToVisit,
								 const IsoSurface& iso) const;

	// Calcul des nouveaux vertex sur les aretes en axe Z a travers la couche courante
	int32 ComputeZVerticesThroughLayer( Vect3DArray& aVertices, VtxIndexArray& aiVtxIndexZLayer,
	                                    BoolArray& abCubesInteressantsCurLayer,
	                                    const Vector3D& vcLowLayerCorner, int32 nCubesX, int32 nCubesY,
									    const DensityArray& afPlane1Potentials, const DensityArray& afPlane2Potentials,
	                                    const AllScansArray& aScansToVisit,
										const IsoSurface& iso) const;

	// Creation des triangles de la couche courante
	void CreateTrianglesForLayer( TriangleArray& aTriangles,
										BoolArray& abInterestCubesCurLayer, int32 nCubesX, // int32 nCubesY,
										const Vect3DArray&  aVertices ,
										const AllScansArray& aScansToVisit) const;



protected:
	// Les tableaux suivants sont utilises uniquement par GenerateGeometryInGrid

	// Tableaux donnant des informations sur les sommets du quadrillage
	DensityArray	m_afPotentialsCurLayer;	// Potentiels (energie - seuil) des sommets pour le plan de Z sup de la couche courante de cubes
	DensityArray	m_afPotentialsPrvLayer;	// Potentiels des sommets pour le plan de Z inf de la couche courante de cubes

	// Tableaux donnant des informations sur les aretes du quadrillage
	VtxIndexArray	m_aiVtxIndexXPrvLayer;	// Idem plan de Z inf
	VtxIndexArray	m_aiVtxIndexYPrvLayer;

	// A recalculer pour chaque couche :
	VtxIndexArray	m_aiVtxIndexXCurLayer;	// Pour le plan de Z sup, indices des vertices crees sur les axes X du quadrillage
	VtxIndexArray	m_aiVtxIndexYCurLayer;	// idem axes Y
	VtxIndexArray	m_aiVtxIndexZLayer;		// Idem pour le Z, sauf qu'en Z il n'y a besoin que d'une epaisseur

	BoolArray		m_abTesselatedCubePrvLayer; // cubes interessants de la couche precedente
	BoolArray		m_abTesselatedCubeCurLayer; // cubes interessants de la couche courante
	BoolArray		m_abDummyLayer;	            // tableau identique aux deux precedents, utilise lorsqu'on ne veut pas des resultats

	AllScansArray	m_aScansPotentialCubesNxt;		// Configurations en lignes des cubes a visiter (optimisation)
	AllScansArray	m_aScansPotentialCubesCur;		// Configurations en lignes des cubes a visiter (optimisation)

	int32           m_nRefineIterCount;
	bool            m_bCleanupTriangles;            // Enleve-t-on les triangles trop petits?

									////////////////////////////////////

private:
	// Vidage du tableau de booleens indiquant les cubes contenant des triangles.
	// Optimise grace a la configuration des cubes a visiter
	void ClearInterestCubes( BoolArray& abCubes, const AllScansArray& aScansToVisit, int32 nCubesX);




};

//////////////////////////////////////////////////////////////////////////////////////////


} // namespace



#endif	// #ifndef V3D_BLOBS_MARCH_CUBES_LAYER_BY_LAYER_H_INCLUDED

